﻿var dialogDiv = null;
var transparentDiv = null;
var dialogWidth = 300;
var dialogHeight = 200;

function createDialog()
{
  dialogDiv = document.createElement("div");

  dialogDiv.style.display = "none";
  dialogDiv.style.width = dialogWidth + "px";
  dialogDiv.style.height = dialogHeight + "px";
  dialogDiv.className = "dialogDiv";
  dialogDiv.id = "dialogDiv";

  transparentDiv = document.createElement("div");

  transparentDiv.style.display = "none";
  transparentDiv.className = "transparentDiv";
  transparentDiv.id = "transparentDiv";

  docWidth = parseInt(document.documentElement.clientWidth);
  docHeight = parseInt(document.documentElement.clientHeight);

  transparentDiv.style.width = docWidth + "px";
  transparentDiv.style.height = docHeight + "px";

  left1 = Math.floor((docWidth - dialogWidth) / 2);
  top1 = Math.floor((docHeight - dialogHeight) / 2);

  dialogDiv.style.top = top1 + "px";
  dialogDiv.style.left = left1 + "px";

  document.body.appendChild(dialogDiv)
  document.body.appendChild(transparentDiv);
}

function showDialog(id)
{
  if(id < 1 || id > 3) return;
  if(!dialogDiv) createDialog();

  url = "http://localhost/dialog" + id + ".html";
  startGETRequest(url, onComplete, onEnd);
  
  dialogDiv.style.display = "block";
  transparentDiv.style.display = "block";
}

function closeDialog()
{
  if(!dialogDiv) return;
  dialogDiv.style.display = "none";
  transparentDiv.style.display = "none";
}

function onComplete(text, xml)
{
  dialogDiv.innerHTML = text;
}

function onEnd()
{
}